﻿//////////////////////////////////////////////
// ToneMappingProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "ToneMappingEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct ToneMappingProgramIdGenerator
	{
		static unsigned long long generate (const ToneMappingEffectInfo& info) ;
	} ;

	struct ToneMappingProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_TONE_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class ToneMappingProgramTracker final : public ProgramTracker<ToneMappingEffectInfo, ToneMappingProgramIdGenerator, ToneMappingProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			ToneMappingProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~ToneMappingProgramTracker () ;
	} ;
}